/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.address;

import java.time.LocalDateTime;
import org.foilage.address.Address;
import org.foilage.address.AddressType;
import org.foilage.address.Country;
import org.foilage.utils.checkers.NotNegativeChecker;
import org.foilage.utils.checkers.NullChecker;

public class AddressImpl
implements Address {
    private final int id;
    private final String addressee;
    private final String careOf;
    private final String streetAddress;
    private final String postalCode;
    private final String city;
    private final Country country;
    private final AddressType type;
    private final LocalDateTime validFrom;
    private final LocalDateTime validTo;

    public AddressImpl(String addressee, String careOf, String streetAddress, String postalCode, String city, Country country, AddressType type, LocalDateTime validFrom, LocalDateTime validTo) {
        this(0, addressee, careOf, streetAddress, postalCode, city, country, type, validFrom, validTo);
    }

    public AddressImpl(int id, String addressee, String careOf, String streetAddress, String postalCode, String city, Country country, AddressType type, LocalDateTime validFrom, LocalDateTime validTo) {
        this.id = NotNegativeChecker.notNegative(id, "AddressImpl.id can't be negative!");
        this.addressee = NullChecker.notNull(addressee, "AddressImpl.addressee can't be null!");
        this.careOf = NullChecker.notNull(careOf, "AddressImpl.careOf can't be null!");
        this.streetAddress = NullChecker.notNull(streetAddress, "AddressImpl.streetAddress can't be null!");
        this.postalCode = NullChecker.notNull(postalCode, "AddressImpl.postalCode can't be null!");
        this.city = NullChecker.notNull(city, "AddressImpl.city can't be null!");
        this.country = NullChecker.notNull(country, "AddressImpl.country can't be null!");
        this.type = NullChecker.notNull(type, "AddressImpl.type can't be null!");
        this.validFrom = NullChecker.notNull(validFrom, "AddressImpl.validFrom can't be null!");
        this.validTo = NullChecker.notNull(validTo, "AddressImpl.validTo can't be null!");
        if (!country.getPostalCodeValidator().isValid(postalCode)) {
            throw new IllegalArgumentException("AddressImpl with id " + id + ". PostalCode " + postalCode + " isn't valid for country " + country.name());
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getAddressee() {
        return this.addressee;
    }

    @Override
    public String getCareOf() {
        return this.careOf;
    }

    @Override
    public String getStreetAddress() {
        return this.streetAddress;
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public String getCity() {
        return this.city;
    }

    @Override
    public Country getCountry() {
        return this.country;
    }

    @Override
    public AddressType getType() {
        return this.type;
    }

    @Override
    public LocalDateTime getValidFrom() {
        return this.validFrom;
    }

    @Override
    public LocalDateTime getValidTo() {
        return this.validTo;
    }
}

