/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.address;

import org.foilage.address.PostalCodeValidator;
import org.foilage.address.format.AddressFormat;
import org.foilage.address.format.AddressFormatSwedish;
import org.foilage.utils.checkers.GreaterThenZeroChecker;
import org.foilage.utils.checkers.NullChecker;

public enum Country {
    UNKNOWN("en", "  ", "   ", 1, "   ", new AddressFormatSwedish(), PostalCodeValidator.UNKNOWN),
    SWEDEN("sv", "SE", "SWE", 752, "SEK", new AddressFormatSwedish(), PostalCodeValidator.NUMERIC_5N);

    private final String languageCode;
    private final String alpha2Code;
    private final String alpha3Code;
    private final int numericCode;
    private final String currencyCode;
    private final AddressFormat addressFormat;
    private final PostalCodeValidator postalCodeValidator;

    private Country(String languageCode, String alpha2Code, String alpha3Code, int numericCode, String currencyCode, AddressFormat addressFormat, PostalCodeValidator postalCodeValidator) {
        this.languageCode = NullChecker.notNull(languageCode, "Country.languageCode can't be null!");
        this.alpha2Code = NullChecker.notNull(alpha2Code, "Country.alpha2Code can't be null!");
        this.alpha3Code = NullChecker.notNull(alpha3Code, "Country.alpha3Code can't be null!");
        this.numericCode = GreaterThenZeroChecker.greaterThenZero(numericCode, "Country.numericCode must be greater then zero!");
        this.currencyCode = NullChecker.notNull(currencyCode, "Country.currencyCode can't be null!");
        this.addressFormat = NullChecker.notNull(addressFormat, "Country.AddressFormat can't be null!");
        this.postalCodeValidator = NullChecker.notNull(postalCodeValidator, "Country.postalCodeValidator can't be null!");
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    public String getAlpha2Code() {
        return this.alpha2Code;
    }

    public String getAlpha3Code() {
        return this.alpha3Code;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public AddressFormat getAddressFormat() {
        return this.addressFormat;
    }

    public PostalCodeValidator getPostalCodeValidator() {
        return this.postalCodeValidator;
    }

    public static Country getByAlpha3Code(String alpha3Code) {
        for (Country country : Country.values()) {
            if (!country.alpha3Code.equalsIgnoreCase(alpha3Code)) continue;
            return country;
        }
        throw new IllegalArgumentException("No country exists with alpha 3 code " + alpha3Code);
    }
}

