/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.address.services;

import org.foilage.address.services.PostalCodeStringValidator;

public class PostalCodeStringValidatorImpl
implements PostalCodeStringValidator {
    private final String validationScheme;
    private final String[] washCharList;

    public PostalCodeStringValidatorImpl(String validationScheme, String[] washCharList) {
        this.validationScheme = validationScheme;
        this.washCharList = washCharList;
    }

    @Override
    public String getValidationScheme() {
        return this.validationScheme;
    }

    @Override
    public boolean isValid(String value) {
        if (this.validationScheme == null || this.validationScheme.length() == 0) {
            return true;
        }
        return value.matches(this.validationScheme);
    }

    @Override
    public String wash(String value) {
        for (String washString : this.washCharList) {
            value = value.replaceAll(washString, "");
        }
        return value;
    }
}

