/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.authorization;

import org.foilage.authorization.AbstractAuthorizationPerformer;
import org.foilage.authorization.AuthorizationAction;
import org.foilage.authorization.Role;
import org.foilage.authorization.User;
import org.foilage.authorization.exceptions.NotAuthorizedException;
import org.foilage.utils.log.Log;

public class UserAuthPerformer
extends AbstractAuthorizationPerformer {
    private final User user;
    protected final Role[] accessRoles;
    protected final Role[] denyAccessRoles;

    public UserAuthPerformer(User user, Role[] accessRoles, Role[] denyAccessRoles) {
        this.user = user;
        this.accessRoles = accessRoles;
        this.denyAccessRoles = denyAccessRoles;
    }

    @Override
    protected void performAuthorization(AuthorizationAction authorizationAction, String resource) throws NotAuthorizedException {
        this.isUserDeniedAccess(this.user, resource);
        this.isUserGrantedAccess(this.user, resource);
    }

    private void isUserDeniedAccess(User user, String resource) throws NotAuthorizedException {
        for (Role role : this.denyAccessRoles) {
            for (Role userRole : user.getUserRoles()) {
                if (role != userRole) continue;
                Log.info("User getId: " + user.getId() + " displayName: " + user.getDisplayName() + " denied access on role: " + (Object)((Object)role) + " to: " + resource);
                throw new NotAuthorizedException();
            }
        }
    }

    private void isUserGrantedAccess(User user, String resource) throws NotAuthorizedException {
        boolean accessGranted = false;
        if (this.accessRoles.length == 0) {
            accessGranted = true;
        } else {
            block0: for (Role role : this.accessRoles) {
                for (Role userRole : user.getUserRoles()) {
                    if (role != userRole) continue;
                    accessGranted = true;
                    continue block0;
                }
            }
        }
        if (!accessGranted) {
            StringBuilder errorBuilder = new StringBuilder();
            errorBuilder.append("User getId: ");
            errorBuilder.append(user.getId());
            errorBuilder.append(" displayName: ");
            errorBuilder.append(user.getDisplayName());
            errorBuilder.append(" not granted access to: ");
            errorBuilder.append(resource);
            errorBuilder.append(", has not any of roles: [");
            for (Role role : this.accessRoles) {
                errorBuilder.append(role.name());
                errorBuilder.append(",");
            }
            errorBuilder.append("]");
            Log.info(errorBuilder.toString());
            throw new NotAuthorizedException();
        }
    }
}

