/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.dao;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.foilage.utils.checkers.AbstractNullChecker;
import org.foilage.utils.log.Log;

public class DAOHandler<T>
extends AbstractNullChecker
implements InvocationHandler {
    protected T delegate;

    public DAOHandler(T delegate) {
        this.delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] argumentList) throws Throwable {
        try {
            this.notNullChecks(method, argumentList);
            Object obj = method.invoke(this.delegate, argumentList);
            return obj;
        }
        catch (InvocationTargetException e) {
            String msg = "DAOHandler reports: " + method.getDeclaringClass().getName() + "." + method.getName() + " - " + e.getCause();
            Log.debug(msg);
            throw e.getCause();
        }
    }
}

