/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.database;

import org.foilage.utils.checkers.HttpURLChecker;
import org.foilage.utils.checkers.NullChecker;

public class ConnectionCredentials {
    private final String database;
    private final String user;
    private final String password;
    private final String serverTimeZone;

    public ConnectionCredentials(String database, String user, String password, String serverTimeZone) {
        this.database = HttpURLChecker.containsOnlyValidCharacters(NullChecker.notNull(database));
        this.user = HttpURLChecker.containsOnlyValidCharacters(NullChecker.notNull(user));
        this.password = HttpURLChecker.containsOnlyValidCharacters(NullChecker.notNull(password));
        this.serverTimeZone = NullChecker.notNull(serverTimeZone);
    }

    public String getDatabase() {
        return this.database;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerTimeZone() {
        return this.serverTimeZone;
    }
}

