/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.foilage.database.CommitType;
import org.foilage.database.ConnectionCredentials;
import org.foilage.database.PoolSettings;
import org.foilage.utils.ObjectPool;
import org.foilage.utils.checkers.NullChecker;
import org.foilage.utils.log.Log;

public class MySQLConnectionPool {
    private final ObjectPool<Connection> pool;

    public MySQLConnectionPool(PoolSettings poolSettings, final ConnectionCredentials credentials) {
        this.pool = new ObjectPool<Connection>(poolSettings.getPoolMinSize(), poolSettings.getPoolMaxSize(), (long)poolSettings.getValidationRefreshTimeInSeconds()){

            @Override
            protected Connection createObject() {
                try {
                    return DriverManager.getConnection("jdbc:mysql://localhost/" + credentials.getDatabase() + "?user=" + credentials.getUser() + "&password=" + credentials.getPassword() + "&useSSL=false&useUnicode=true&useJDBCCompliantTimezoneShift=true&useLegacyDatetimeCode=false&serverTimezone=" + credentials.getServerTimeZone());
                }
                catch (SQLException e) {
                    Log.error("Problem creating connection for database pool - " + e.getClass().toString() + " - " + e.getMessage());
                    return null;
                }
            }
        };
    }

    public Connection getConnection(CommitType commitType) {
        NullChecker.notNull(commitType, "MySQLConnectionPool.getConnection CommitType cant be null!");
        try {
            Connection con = this.pool.borrowObject();
            while (!con.isValid(1)) {
                con = this.pool.borrowObject();
            }
            if (commitType == CommitType.CONTROL) {
                con.setAutoCommit(false);
            } else {
                con.setAutoCommit(true);
            }
            return con;
        }
        catch (SQLException e) {
            Log.error("Could not get database connection from pool " + e.getMessage());
            throw new RuntimeException("Could not get database connection from pool " + e.getMessage(), e);
        }
    }

    public void returnConnection(Connection con, PreparedStatement ps) {
        NullChecker.notNull(con, "MySQLConnectionPool.returnConnection Connection cant be null!");
        try {
            if (!con.getAutoCommit()) {
                con.commit();
            }
            if (ps != null) {
                ps.close();
            }
            this.pool.returnObject(con);
        }
        catch (SQLException e) {
            Log.error("MySQLConnectionPool.returnConnection Problem releasing pooled connection " + e.getMessage());
        }
    }
}

