/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html;

import java.util.ArrayList;
import java.util.List;
import org.foilage.http.html.ComponentBuilder;
import org.foilage.http.html.HtmlComponent;
import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.HtmlComponentStorage;

public class ComponentGroup
extends HtmlComponentImpl {
    private final List<HtmlComponent> components;

    public ComponentGroup(HtmlComponent component) {
        ArrayList<HtmlComponent> list = new ArrayList<HtmlComponent>();
        list.add(component);
        this.components = list;
    }

    public ComponentGroup(List<HtmlComponent> components) {
        this.components = components;
        this.tabOffset = 0;
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        for (HtmlComponent comp : this.components) {
            this.htmlBuilder.append(comp.getHtml(this, false));
        }
    }

    public static class Builder
    implements ComponentBuilder<ComponentGroup>,
    HtmlComponentStorage<HtmlComponent> {
        private final List<HtmlComponent> components = new ArrayList<HtmlComponent>();

        @Override
        public void add(HtmlComponent ... htmlComponent) {
            for (HtmlComponent comp : htmlComponent) {
                this.components.add(comp);
            }
        }

        @Override
        public void add(HtmlComponent component) {
            this.components.add(component);
        }

        @Override
        public ComponentGroup build() {
            return new ComponentGroup(this.components);
        }
    }
}

