/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body;

import java.util.HashMap;
import java.util.Map;
import org.foilage.http.html.BaseEventComponentBuilder;
import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.Util;
import org.foilage.http.html.body.Target;
import org.foilage.http.html.body.Text;
import org.foilage.model.MimeType;

public class A
extends HtmlComponentImpl {
    private final Builder builder;

    public A(String href, String linkText) {
        this.builder = new Builder(href, linkText);
    }

    public A(Builder builder) {
        this.builder = builder;
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<a");
        this.htmlBuilder.append(" href=\"");
        this.htmlBuilder.append(this.builder.generateHref());
        this.htmlBuilder.append("\"");
        this.htmlBuilder.append(this.builder.addGeneralComponents());
        if (this.builder.hrefLang != null) {
            this.htmlBuilder.append(" hreflang=\"");
            this.htmlBuilder.append(this.builder.hrefLang);
            this.htmlBuilder.append("\"");
        }
        if (this.builder.media != null) {
            this.htmlBuilder.append(" media=\"");
            this.htmlBuilder.append(this.builder.media);
            this.htmlBuilder.append("\"");
        }
        if (this.builder.target != null) {
            this.htmlBuilder.append(" target=\"");
            this.htmlBuilder.append(this.builder.target);
            this.htmlBuilder.append("\"");
        }
        if (this.builder.type != null) {
            this.htmlBuilder.append(" type=\"");
            this.htmlBuilder.append(this.builder.type.toString());
            this.htmlBuilder.append("\"");
        }
        this.htmlBuilder.append(">\n");
        this.htmlBuilder.append(this.builder.linkComponent.getHtml(this, false));
        this.htmlBuilder.append("\n");
        this.htmlBuilder.append(Util.tab(this.tabs));
        this.htmlBuilder.append("</a>\n");
    }

    public static class Builder
    extends BaseEventComponentBuilder<A, Builder> {
        protected HtmlComponentImpl linkComponent = null;
        protected Map<String, String> parameters = new HashMap<String, String>();
        protected String href = null;
        protected String hrefLang = null;
        protected String media = null;
        protected String target = null;
        protected MimeType type = null;

        public Builder(String href, String linkText) {
            this.href = href;
            this.linkComponent = new Text(linkText);
        }

        public Builder(String href, HtmlComponentImpl linkComponent) {
            this.href = href;
            this.linkComponent = linkComponent;
        }

        public Builder(String href, Map<String, String> parameters, String linkText) {
            this.href = href;
            this.parameters = parameters;
            this.linkComponent = new Text(linkText);
        }

        public Builder(String href, Map<String, String> parameters, HtmlComponentImpl linkComponent) {
            this.href = href;
            this.parameters = parameters;
            this.linkComponent = linkComponent;
        }

        @Override
        public A build() {
            return new A(this);
        }

        public String generateHref() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.href);
            boolean hasPageAction = false;
            boolean first = true;
            for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
                if (first && hasPageAction) {
                    sb.append("?");
                    first = false;
                } else {
                    sb.append("&");
                }
                sb.append((Object)entry.getKey());
                sb.append("=");
                sb.append((Object)entry.getValue());
            }
            return sb.toString();
        }

        public Builder href(String href) {
            this.href = href;
            return this;
        }

        public Builder hrefLang(String hrefLang) {
            this.hrefLang = hrefLang;
            return this;
        }

        public Builder media(String media) {
            this.media = media;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public Builder target(Target target) {
            this.target = target.getValue();
            return this;
        }

        public Builder type(MimeType type) {
            this.type = type;
            return this;
        }

        public Builder linkComponent(HtmlComponentImpl linkComponent) {
            this.linkComponent = linkComponent;
            return this;
        }

        public Builder linkComponent(String linkText) {
            this.linkComponent = new Text(linkText);
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }
    }
}

