/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body;

import java.util.ArrayList;
import java.util.List;
import org.foilage.http.html.BaseEventComponentBuilder;
import org.foilage.http.html.HtmlComponent;
import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.HtmlComponentStorage;
import org.foilage.http.html.Util;

public class Div
extends HtmlComponentImpl {
    private final List<HtmlComponent> components;
    private final Builder builder;

    public Div(List<HtmlComponent> components, Builder builder) {
        this.components = components;
        this.builder = builder;
        this.tabOffset = 0;
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<div ");
        this.htmlBuilder.append(this.builder.addGeneralComponents());
        this.htmlBuilder.append(">\n");
        for (HtmlComponent component : this.components) {
            this.htmlBuilder.append(component.getHtml(this, false));
        }
        this.htmlBuilder.append(Util.tab(this.tabs));
        this.htmlBuilder.append("</div>");
        if (this.builder.rowBreak) {
            this.htmlBuilder.append("\n");
        }
    }

    public static class Builder
    extends BaseEventComponentBuilder<Div, Builder>
    implements HtmlComponentStorage<HtmlComponent> {
        private List<HtmlComponent> components = new ArrayList<HtmlComponent>();
        private boolean rowBreak = true;

        public Builder rowBreak(boolean rowBreak) {
            this.rowBreak = rowBreak;
            return this;
        }

        @Override
        public Div build() {
            return new Div(this.components, this);
        }

        @Override
        public void add(HtmlComponent htmlComponent) {
            this.components.add(htmlComponent);
        }

        @Override
        public void add(HtmlComponent ... htmlComponent) {
            for (HtmlComponent comp : htmlComponent) {
                this.components.add(comp);
            }
        }
    }
}

