/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body;

import org.foilage.http.html.BaseEventComponentBuilder;
import org.foilage.http.html.HtmlComponentImpl;

public class Img
extends HtmlComponentImpl {
    private final Builder builder;

    public Img(String src) {
        this.builder = new Builder(src);
    }

    public Img(String src, String alt) {
        this.builder = new Builder(src, alt);
    }

    public Img(Builder builder) {
        this.builder = builder;
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<img src=\"");
        this.htmlBuilder.append(this.builder.src);
        this.htmlBuilder.append("\"");
        if (this.builder.alt != null) {
            this.htmlBuilder.append(" alt=\"");
            this.htmlBuilder.append(this.builder.alt);
            this.htmlBuilder.append("\"");
        }
        this.htmlBuilder.append(this.builder.addGeneralComponents());
        if (this.builder.width >= 0) {
            this.htmlBuilder.append(" width=\"");
            this.htmlBuilder.append(this.builder.width);
            this.htmlBuilder.append("\"");
        }
        if (this.builder.height >= 0) {
            this.htmlBuilder.append(" height=\"");
            this.htmlBuilder.append(this.builder.height);
            this.htmlBuilder.append("\"");
        }
        this.htmlBuilder.append(">\n");
    }

    public static class Builder
    extends BaseEventComponentBuilder<Img, Builder> {
        private String alt = null;
        private int height = -1;
        private String src = null;
        private int width = -1;

        public Builder(String src) {
            this.src = src;
        }

        public Builder(String src, String alt) {
            this.src = src;
            this.alt = alt;
        }

        @Override
        public Img build() {
            return new Img(this);
        }

        public Builder alt(String alt) {
            this.alt = alt;
            return this;
        }

        public Builder height(int height) {
            this.height = height;
            return this;
        }

        public Builder src(String src) {
            this.src = src;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }
    }
}

