/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body;

import org.foilage.http.html.CharacterSet;
import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.Util;
import org.foilage.model.MimeType;
import org.foilage.utils.checkers.NullChecker;

public class Script
extends HtmlComponentImpl {
    private final Builder builder;

    public Script(Builder builder) {
        this.builder = NullChecker.notNull(builder);
    }

    public Script(String script) {
        this.builder = new Builder(script);
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<script");
        if (this.builder.async) {
            this.htmlBuilder.append(" async");
        }
        if (this.builder.charset != null) {
            this.htmlBuilder.append(" charset=\"");
            this.htmlBuilder.append(this.builder.charset.getEncoding());
            this.htmlBuilder.append("\"");
        }
        if (this.builder.defer) {
            this.htmlBuilder.append(" defer");
        }
        if (this.builder.src != null) {
            this.htmlBuilder.append(" src=\"");
            this.htmlBuilder.append(this.builder.src);
            this.htmlBuilder.append("\"");
        }
        if (this.builder.type != null) {
            this.htmlBuilder.append(" type=\"");
            this.htmlBuilder.append(this.builder.type.toString());
            this.htmlBuilder.append("\"");
        }
        this.htmlBuilder.append(">\n");
        if (this.builder.script != null) {
            this.htmlBuilder.append(this.builder.script);
        }
        this.htmlBuilder.append(Util.tab(this.tabs));
        this.htmlBuilder.append("</script>");
        if (!onSameRow) {
            this.htmlBuilder.append("\n");
        }
    }

    public static class Builder {
        private boolean async;
        private CharacterSet charset;
        private boolean defer;
        private String src;
        private MimeType type;
        private String script;

        public Builder() {
        }

        public Builder(String script) {
            this.script = script;
        }

        public Builder async(boolean async) {
            this.async = async;
            return this;
        }

        public Builder charset(CharacterSet charset) {
            this.charset = charset;
            return this;
        }

        public Builder defer(boolean defer) {
            this.defer = defer;
            return this;
        }

        public Builder src(String src) {
            this.src = src;
            return this;
        }

        public Builder type(MimeType type) {
            this.type = type;
            return this;
        }

        public Builder script(String script) {
            this.script = script;
            return this;
        }

        public Script build() {
            return new Script(this);
        }
    }
}

