/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body;

import java.util.ArrayList;
import java.util.List;
import org.foilage.http.html.BaseEventComponentBuilder;
import org.foilage.http.html.HtmlComponent;
import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.HtmlComponentStorage;
import org.foilage.http.html.Util;
import org.foilage.http.html.body.Text;
import org.foilage.utils.checkers.NullChecker;

public class Span
extends HtmlComponentImpl {
    private final Builder builder;

    public Span(Builder builder) {
        this.builder = builder;
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<span ");
        this.htmlBuilder.append(this.builder.addGeneralComponents());
        this.htmlBuilder.append(">\n");
        for (HtmlComponent component : this.builder.components) {
            this.htmlBuilder.append(component.getHtml(this, false));
        }
        this.htmlBuilder.append(Util.tab(this.tabs));
        this.htmlBuilder.append("</span>\n");
    }

    public static class Builder
    extends BaseEventComponentBuilder<Span, Builder>
    implements HtmlComponentStorage<HtmlComponent> {
        private List<HtmlComponent> components = new ArrayList<HtmlComponent>();

        public Builder() {
        }

        public Builder(String text) {
            this.components.add(new Text(text));
        }

        public Builder(HtmlComponent component) {
            this.components.add(component);
        }

        public Builder(HtmlComponent ... component) {
            for (HtmlComponent comp : component) {
                this.components.add(comp);
            }
        }

        @Override
        public Span build() {
            return new Span(this);
        }

        @Override
        public void add(HtmlComponent htmlComponent) {
            this.components.add(NullChecker.notNull(htmlComponent));
        }

        @Override
        public void add(HtmlComponent ... htmlComponent) {
            for (HtmlComponent comp : htmlComponent) {
                this.components.add(NullChecker.notNull(comp));
            }
        }
    }
}

