/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body;

import java.util.ArrayList;
import java.util.List;
import org.foilage.http.html.BaseEventComponentBuilder;
import org.foilage.http.html.HtmlComponent;
import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.HtmlComponentStorage;
import org.foilage.http.html.Util;
import org.foilage.http.html.body.TableCell;
import org.foilage.http.html.body.Text;
import org.foilage.utils.checkers.GreaterThenZeroChecker;
import org.foilage.utils.checkers.NullChecker;

public class TD
extends TableCell {
    private final Builder builder;

    public TD(Builder builder) {
        this.builder = NullChecker.notNull(builder);
    }

    public TD(String text) {
        this.builder = new Builder(text);
    }

    public TD(HtmlComponent comp) {
        this.builder = new Builder(comp);
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<td ");
        this.htmlBuilder.append(this.builder.addGeneralComponents());
        this.htmlBuilder.append(">\n");
        for (HtmlComponent component : this.builder.componentList) {
            this.htmlBuilder.append(component.getHtml(this, false));
        }
        this.htmlBuilder.append(Util.tab(this.tabs));
        this.htmlBuilder.append("</td>");
        if (!onSameRow) {
            this.htmlBuilder.append("\n");
        }
    }

    public static class Builder
    extends BaseEventComponentBuilder<TD, Builder>
    implements HtmlComponentStorage<HtmlComponent> {
        private int colSpan;
        private int rowSpan;
        private String headers;
        private List<HtmlComponent> componentList = new ArrayList<HtmlComponent>();

        public Builder() {
        }

        public Builder(String text) {
            this.componentList.add(new Text(text));
        }

        public Builder(HtmlComponent comp) {
            this.componentList.add(comp);
        }

        @Override
        public TD build() {
            return new TD(this);
        }

        public Builder colSpan(int colSpan) {
            this.colSpan = GreaterThenZeroChecker.greaterThenZero(colSpan);
            return this;
        }

        public Builder rowSpan(int rowSpan) {
            this.rowSpan = GreaterThenZeroChecker.greaterThenZero(rowSpan);
            return this;
        }

        public Builder headers(String headers) {
            this.headers = NullChecker.notNull(headers);
            return this;
        }

        @Override
        public void add(HtmlComponent htmlComponent) {
            this.componentList.add(NullChecker.notNull(htmlComponent));
        }

        @Override
        public void add(HtmlComponent ... htmlComponent) {
            for (HtmlComponent comp : htmlComponent) {
                this.componentList.add(NullChecker.notNull(comp));
            }
        }
    }
}

