/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body.form;

import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.body.form.InputBuilder;

public class Checkbox
extends HtmlComponentImpl {
    private final Builder builder;

    public Checkbox(Builder builder) {
        this.builder = builder;
    }

    public Checkbox(String name, String value) {
        Builder b;
        this.builder = b = new Builder(name, value);
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<input");
        this.htmlBuilder.append(this.builder.addGeneralComponents());
        if (this.builder.checked) {
            this.htmlBuilder.append(" checked");
        }
        this.htmlBuilder.append(" type=\"checkbox\"");
        this.htmlBuilder.append(">");
        if (this.builder.title != null) {
            this.htmlBuilder.append(" ");
            this.htmlBuilder.append(this.builder.title);
        }
        this.htmlBuilder.append("\n");
    }

    public static class Builder
    extends InputBuilder<Checkbox, Builder> {
        private boolean checked = false;
        private String title = null;

        public Builder() {
        }

        public Builder(String name, String value) {
            this.name(name);
            this.value(value);
            this.title(value);
        }

        public Builder checked(boolean checked) {
            this.checked = checked;
            return this;
        }

        @Override
        public Builder title(String title) {
            this.title = title;
            return this;
        }

        @Override
        public Checkbox build() {
            return new Checkbox(this);
        }
    }
}

