/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body.form;

import java.util.ArrayList;
import java.util.List;
import org.foilage.http.html.BaseEventComponentBuilder;
import org.foilage.http.html.CharacterSet;
import org.foilage.http.html.HtmlComponent;
import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.Util;
import org.foilage.http.html.body.EncodingType;
import org.foilage.http.html.body.Target;
import org.foilage.http.html.body.form.FormMethod;

public class Form
extends HtmlComponentImpl {
    private final Builder builder;

    public Form(Builder builder) {
        this.builder = builder;
        this.tabOffset = 0;
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<form");
        this.htmlBuilder.append(this.builder.addGeneralComponents());
        if (this.builder.acceptCharset != null) {
            this.htmlBuilder.append(" accept-charset=\"");
            this.htmlBuilder.append(this.builder.acceptCharset.getEncoding());
            this.htmlBuilder.append("\" ");
        }
        if (this.builder.action != null) {
            this.htmlBuilder.append(" action=\"");
            this.htmlBuilder.append(this.builder.action);
            this.htmlBuilder.append("\" ");
        }
        if (!this.builder.autocomplete) {
            this.htmlBuilder.append(" autoComplete=\"off\" ");
        }
        if (this.builder.enctype != null) {
            this.htmlBuilder.append(" enctype=\"");
            this.htmlBuilder.append(this.builder.enctype.getEncoding());
            this.htmlBuilder.append("\" ");
        }
        if (this.builder.method != null) {
            this.htmlBuilder.append(" method=\"");
            this.htmlBuilder.append(this.builder.method.name().toLowerCase());
            this.htmlBuilder.append("\" ");
        }
        if (this.builder.name != null) {
            this.htmlBuilder.append(" name=\"");
            this.htmlBuilder.append(this.builder.name);
            this.htmlBuilder.append("\" ");
        }
        if (this.builder.novalidate) {
            this.htmlBuilder.append(" novalidate ");
        }
        if (this.builder.target != null) {
            this.htmlBuilder.append(" target=\"");
            this.htmlBuilder.append(this.builder.target.getValue());
            this.htmlBuilder.append("\" ");
        }
        this.htmlBuilder.append(">\n");
        for (HtmlComponent component : this.builder.components) {
            this.htmlBuilder.append(component.getHtml(this, false));
        }
        this.htmlBuilder.append(Util.tab(this.tabs));
        this.htmlBuilder.append("</form>\n");
    }

    public static class Builder
    extends BaseEventComponentBuilder<Form, Builder> {
        private List<HtmlComponent> components;
        private CharacterSet acceptCharset = null;
        private String action = null;
        private boolean autocomplete = true;
        private EncodingType enctype = null;
        private FormMethod method = FormMethod.POST;
        private String name = null;
        private boolean novalidate = false;
        private Target target = null;

        public Builder() {
            this.components = new ArrayList<HtmlComponent>();
        }

        @Override
        public Form build() {
            return new Form(this);
        }

        public Builder add(HtmlComponent component) {
            this.components.add(component);
            return this;
        }

        public Builder add(HtmlComponent ... component) {
            for (HtmlComponent comp : component) {
                this.components.add(comp);
            }
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder autocomplete(boolean autocomplete) {
            this.autocomplete = autocomplete;
            return this;
        }

        public Builder characterSet(CharacterSet acceptCharset) {
            this.acceptCharset = acceptCharset;
            return this;
        }

        public Builder enctype(EncodingType enctype) {
            this.enctype = enctype;
            return this;
        }

        public Builder method(FormMethod method) {
            this.method = method;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder novalidate(boolean novalidate) {
            this.novalidate = novalidate;
            return this;
        }

        public Builder target(Target target) {
            this.target = target;
            return this;
        }
    }
}

