/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body.form;

import org.foilage.http.html.BaseEventComponentBuilder;

public abstract class InputBuilder<B, T>
extends BaseEventComponentBuilder<B, T> {
    private boolean autoComplete = true;
    private boolean autoFocus;
    private boolean disabled;
    private String form = null;
    private String name = null;
    private String pattern = null;
    private boolean readonly;
    private String value = null;
    private String onChange = null;

    @Override
    public String addGeneralComponents() {
        StringBuilder html = new StringBuilder();
        html.append(super.addGeneralComponents());
        if (!this.autoComplete) {
            html.append(" autocomplete=\"off\"");
        }
        if (this.autoFocus) {
            html.append(" autofocus");
        }
        if (this.disabled) {
            html.append(" disabled");
        }
        if (this.form != null) {
            html.append(" form=\"");
            html.append(this.form);
            html.append("\"");
        }
        if (this.name != null) {
            html.append(" name=\"");
            html.append(this.name);
            html.append("\"");
        }
        if (this.onChange != null) {
            html.append(" onChange=\"");
            html.append(this.onChange);
            html.append("\"");
        }
        if (this.pattern != null) {
            html.append(" pattern=\"");
            html.append(this.pattern);
            html.append("\"");
        }
        if (this.readonly) {
            html.append(" readonly");
        }
        if (this.value != null) {
            html.append(" value=\"");
            html.append(this.value);
            html.append("\"");
        }
        return html.toString();
    }

    public T autoComplete(boolean autoComplete) {
        this.autoComplete = autoComplete;
        return (T)this;
    }

    public T autoFocus(boolean autoFocus) {
        this.autoFocus = autoFocus;
        return (T)this;
    }

    public T disabled(boolean disable) {
        this.disabled = disable;
        return (T)this;
    }

    public T form(String form) {
        this.form = form;
        return (T)this;
    }

    public T name(String name) {
        this.name = name;
        return (T)this;
    }

    public T pattern(String pattern) {
        this.pattern = pattern;
        return (T)this;
    }

    public T readonly(boolean readonly) {
        this.readonly = readonly;
        return (T)this;
    }

    public T value(String value) {
        this.value = value;
        return (T)this;
    }

    public T onChange(String onChange) {
        this.onChange = onChange;
        return (T)this;
    }
}

