/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body.form;

import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.body.form.InputBuilder;
import org.foilage.utils.checkers.NullChecker;

public class RadioButton
extends HtmlComponentImpl {
    private final Builder builder;

    public RadioButton(Builder builder) {
        this.builder = NullChecker.notNull(builder);
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<input");
        this.htmlBuilder.append(this.builder.addGeneralComponents());
        this.htmlBuilder.append(" type=\"radio\"");
        if (this.builder.checked) {
            this.htmlBuilder.append(" checked");
        }
        this.htmlBuilder.append(">");
        if (this.builder.buttonText != null) {
            this.htmlBuilder.append(this.builder.buttonText);
        }
        this.htmlBuilder.append("\n");
    }

    public static class Builder
    extends InputBuilder<RadioButton, Builder> {
        private boolean checked = false;
        private String buttonText;

        @Override
        public RadioButton build() {
            return new RadioButton(this);
        }

        public Builder checked(boolean checked) {
            this.checked = checked;
            return this;
        }

        public Builder buttonText(String buttonText) {
            this.buttonText = buttonText;
            return this;
        }
    }
}

