/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body.form;

import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.body.Target;
import org.foilage.http.html.body.form.FormMethod;
import org.foilage.http.html.body.form.InputBuilder;

public class Submit
extends HtmlComponentImpl {
    private final Builder builder;

    public Submit(Builder builder) {
        this.builder = builder;
    }

    public Submit(String name, String value) {
        this.builder = new Builder(name, value);
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<input");
        this.htmlBuilder.append(this.builder.addGeneralComponents());
        if (this.builder.formAction != null) {
            this.htmlBuilder.append(" formaction=\"");
            this.htmlBuilder.append(this.builder.formAction);
            this.htmlBuilder.append("\"");
        }
        if (this.builder.formEncType != null) {
            this.htmlBuilder.append(" formenctype=\"");
            this.htmlBuilder.append(this.builder.formEncType);
            this.htmlBuilder.append("\"");
        }
        if (this.builder.formMethod != null) {
            this.htmlBuilder.append(" formmethod=\"");
            this.htmlBuilder.append(this.builder.formMethod.getValue());
            this.htmlBuilder.append("\"");
        }
        if (this.builder.formTarget != null) {
            this.htmlBuilder.append(" formtarget=\"");
            this.htmlBuilder.append(this.builder.formTarget.getValue());
            this.htmlBuilder.append("\"");
        }
        this.htmlBuilder.append(" type=\"submit\"");
        this.htmlBuilder.append(">\n");
    }

    public static class Builder
    extends InputBuilder<Submit, Builder> {
        private String formAction = null;
        private String formEncType = null;
        private FormMethod formMethod = null;
        private Target formTarget = null;

        public Builder() {
        }

        public Builder(String name, String value) {
            this.name(name);
            this.value(value);
        }

        public Builder formAction(String formAction) {
            this.formAction = formAction;
            return this;
        }

        public Builder formEncType(String formEncType) {
            this.formEncType = formEncType;
            return this;
        }

        public Builder formMethod(FormMethod formMethod) {
            this.formMethod = formMethod;
            return this;
        }

        public Builder formTarget(Target formTarget) {
            this.formTarget = formTarget;
            return this;
        }

        @Override
        public Submit build() {
            return new Submit(this);
        }
    }
}

