/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.body.form;

import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.body.form.InputBuilder;

public class TextArea
extends HtmlComponentImpl {
    private final Builder builder;

    public TextArea(Builder builder) {
        this.builder = builder;
    }

    public TextArea(String name) {
        Builder b = new Builder();
        b.name(name);
        this.builder = b;
    }

    public TextArea(String name, String text) {
        Builder b;
        this.builder = b = new Builder(name, text);
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<textarea");
        this.htmlBuilder.append(this.builder.addGeneralComponents());
        if (this.builder.placeholder != null) {
            this.htmlBuilder.append("placeholder=\"");
            this.htmlBuilder.append(this.builder.placeholder);
            this.htmlBuilder.append("\"");
        }
        if (this.builder.required) {
            this.htmlBuilder.append(" required");
        }
        this.htmlBuilder.append(">");
        this.htmlBuilder.append(this.builder.text);
        this.htmlBuilder.append("</textarea>\n");
    }

    public static class Builder
    extends InputBuilder<TextArea, Builder> {
        private String text = "";
        private String placeholder = null;
        private boolean required = false;

        public Builder() {
        }

        public Builder(String name, String text) {
            this.text = text;
            this.name(name);
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public Builder placeholder(String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public Builder required(boolean required) {
            this.required = required;
            return this;
        }

        @Override
        public TextArea build() {
            return new TextArea(this);
        }
    }
}

