/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.head;

import org.foilage.http.html.ComponentBuilder;
import org.foilage.http.html.CrossOrigin;
import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.head.HeadComponent;
import org.foilage.http.html.head.Rel;
import org.foilage.model.MimeType;

public class Link
extends HtmlComponentImpl
implements HeadComponent {
    private Builder builder;

    public Link(Builder builder) {
        this.builder = builder;
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<link");
        if (this.builder.crossOrigin != null) {
            this.htmlBuilder.append(" crossorigin=\"");
            this.htmlBuilder.append(this.builder.crossOrigin.getValue());
            this.htmlBuilder.append("\"");
        }
        this.htmlBuilder.append(" href=\"");
        this.htmlBuilder.append(this.builder.href);
        this.htmlBuilder.append("\"");
        if (this.builder.media != null) {
            this.htmlBuilder.append(" media=\"");
            this.htmlBuilder.append(this.builder.media);
            this.htmlBuilder.append("\"");
        }
        if (this.builder.rel != null) {
            this.htmlBuilder.append(" rel=\"");
            this.htmlBuilder.append(this.builder.rel.getValue());
            this.htmlBuilder.append("\"");
            if (this.builder.rel == Rel.ICON && this.builder.sizes != null) {
                this.htmlBuilder.append(" sizes=\"");
                this.htmlBuilder.append(this.builder.sizes);
                this.htmlBuilder.append("\"");
            }
        }
        if (this.builder.mimeType != null) {
            this.htmlBuilder.append(" type=\"");
            this.htmlBuilder.append(this.builder.mimeType.toString());
            this.htmlBuilder.append("\"");
        }
        this.htmlBuilder.append(">\n");
    }

    public static class Builder
    implements ComponentBuilder<Link> {
        private CrossOrigin crossOrigin = null;
        private String href = "";
        private String media = null;
        private Rel rel = null;
        private String sizes = null;
        private MimeType mimeType = null;

        public Builder(String href, Rel rel) {
            this.href = href;
            this.rel = rel;
        }

        @Override
        public Link build() {
            return new Link(this);
        }

        public Builder crossOrigin(CrossOrigin crossOrigin) {
            this.crossOrigin = crossOrigin;
            return this;
        }

        public Builder href(String href) {
            this.href = href;
            return this;
        }

        public Builder media(String media) {
            this.media = media;
            return this;
        }

        public Builder rel(Rel rel) {
            this.rel = rel;
            return this;
        }

        public Builder sizes(String sizes) {
            this.sizes = sizes;
            return this;
        }

        public Builder mimeType(MimeType mimeType) {
            this.mimeType = mimeType;
            return this;
        }
    }
}

