/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.head;

import org.foilage.http.html.ComponentBuilder;
import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.head.HeadComponent;
import org.foilage.http.html.head.MetaName;

public class Meta
extends HtmlComponentImpl
implements HeadComponent {
    private final MetaName metaName;
    private final String content;

    public Meta(MetaName metaName, String content) {
        this.metaName = metaName;
        this.content = content;
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<meta");
        if (MetaName.CHARSET == this.metaName) {
            this.htmlBuilder.append(" charset=\"");
            this.htmlBuilder.append(this.content);
            this.htmlBuilder.append("\"");
        } else {
            this.htmlBuilder.append(" name=\"");
            this.htmlBuilder.append(this.metaName.getId());
            this.htmlBuilder.append("\"");
            this.htmlBuilder.append(" content=\"");
            this.htmlBuilder.append(this.content);
            this.htmlBuilder.append("\"");
        }
        this.htmlBuilder.append(">\n");
    }

    public static class Builder
    implements ComponentBuilder<Meta> {
        private final MetaName metaName;
        private final String content;

        public Builder(MetaName metaName, String content) {
            this.metaName = metaName;
            this.content = content;
        }

        @Override
        public Meta build() {
            return new Meta(this.metaName, this.content);
        }
    }
}

