/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.html.head;

import org.foilage.http.html.CharacterSet;
import org.foilage.http.html.ComponentBuilder;
import org.foilage.http.html.HtmlComponentImpl;
import org.foilage.http.html.head.HeadComponent;
import org.foilage.model.MimeType;

public class Script
extends HtmlComponentImpl
implements HeadComponent {
    private final Builder builder;

    public Script(Builder builder) {
        this.builder = builder;
    }

    public Script(String src) {
        this.builder = new Builder(src);
    }

    @Override
    protected void generateHtmlSpecific(HtmlComponentImpl parent, boolean onSameRow) {
        this.htmlBuilder.append("<script ");
        if (this.builder.async) {
            this.htmlBuilder.append("async ");
        }
        if (this.builder.charset != null) {
            this.htmlBuilder.append("charset=\"");
            this.htmlBuilder.append(this.builder.charset.getEncoding());
            this.htmlBuilder.append("\" ");
        }
        if (this.builder.defer) {
            this.htmlBuilder.append("defer ");
        }
        if (this.builder.src != null) {
            this.htmlBuilder.append("src=\"");
            this.htmlBuilder.append(this.builder.src);
            this.htmlBuilder.append("\" ");
        }
        if (this.builder.type != null) {
            this.htmlBuilder.append("type=\"");
            this.htmlBuilder.append(this.builder.type.getMimeType());
            this.htmlBuilder.append("\" ");
        }
        this.htmlBuilder.append(">");
        if (this.builder.script != null) {
            this.htmlBuilder.append(this.builder.script);
        }
        this.htmlBuilder.append("</script>\n");
    }

    public static class Builder
    implements ComponentBuilder<Script> {
        private boolean async = false;
        private CharacterSet charset = CharacterSet.UTF8;
        private boolean defer = false;
        private String src = null;
        private MimeType type = null;
        private String script = null;

        public Builder() {
        }

        public Builder(String src) {
            this.src = src;
        }

        @Override
        public Script build() {
            return new Script(this);
        }

        public Builder async(boolean async) {
            this.async = async;
            return this;
        }

        public Builder charset(CharacterSet charset) {
            this.charset = charset;
            return this;
        }

        public Builder defer(boolean defer) {
            this.defer = defer;
            return this;
        }

        public Builder src(String src) {
            this.src = src;
            return this;
        }

        public Builder script(String script) {
            this.script = script;
            return this;
        }

        public Builder type(MimeType type) {
            this.type = type;
            return this;
        }
    }
}

