/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.foilage.authorization.Role;
import org.foilage.authorization.exceptions.NotAuthenticatedException;
import org.foilage.authorization.exceptions.NotAuthorizedException;
import org.foilage.http.RequestMethod;
import org.foilage.http.StatusCode;
import org.foilage.http.exceptions.HttpRedirect;
import org.foilage.http.exceptions.HttpRequestLineException;
import org.foilage.http.exceptions.URLNotFoundException;
import org.foilage.http.server.FileRenderer;
import org.foilage.http.server.HttpServerEnvironment;
import org.foilage.http.server.LogicWorker;
import org.foilage.http.server.PreEndPointLogicWorker;
import org.foilage.http.server.RequestData;
import org.foilage.http.server.RequestReader;
import org.foilage.http.server.ResponseDataImpl;
import org.foilage.http.server.ServerEndPoint;
import org.foilage.http.server.SessionStore;
import org.foilage.http.server.UploadedFile;
import org.foilage.utils.log.Log;

public class ClientSocketThread
implements Runnable {
    private final Socket socket;
    private final HttpServerEnvironment serverEnv;
    private static final RequestData errorRequest = new RequestData(RequestMethod.GET, "", "", new HashMap<String, String>(), new HashMap<String, String>(), new ArrayList<UploadedFile>(), "");

    public ClientSocketThread(Socket socket, HttpServerEnvironment serverEnv) {
        this.socket = socket;
        this.serverEnv = serverEnv;
    }

    @Override
    public void run() {
        Log.debug("Call: " + Thread.currentThread().getName() + " count: " + Thread.activeCount());
        long startTime = System.currentTimeMillis();
        try {
            OutputStream out;
            block17: {
                out = this.socket.getOutputStream();
                try {
                    RequestData req = RequestReader.INSTANCE.readInData(this.serverEnv.getBaseUrl(), this.socket.getInputStream(), this.serverEnv.getBufferSize());
                    req.setSession(SessionStore.I.getSession(req.getHeader("cookie"), this.socket.getRemoteSocketAddress().toString().split(":")[0].replaceAll("/", "")));
                    errorRequest.setSession(req.getSession());
                    for (PreEndPointLogicWorker preWorker : this.serverEnv.getPreEndPointWorkers()) {
                        preWorker.performLogic(this.serverEnv, req);
                    }
                    Log.debug(req.getMethod().name());
                    try {
                        if (req.getHeaderMap().containsKey("accept") && req.getHeaderMap().get("accept").startsWith("image")) {
                            FileRenderer.INSTANCE.renderFile(out, req.getUrl(), this.serverEnv.getDataFilesRoot());
                            break block17;
                        }
                        if (req.getHeaderMap().containsKey("accept") && req.getHeaderMap().get("accept").startsWith("text/css")) {
                            FileRenderer.INSTANCE.renderFile(out, req.getUrl(), this.serverEnv.getDataFilesRoot());
                            break block17;
                        }
                        ServerEndPoint endPoint = this.serverEnv.findEndPointByUrl(req.getUrl());
                        this.authorize(endPoint, req.getSession().getRoleList());
                        Object resp = endPoint.createResponseData();
                        List<LogicWorker> logicWorkerList = endPoint.getPreRenderLogicList();
                        for (LogicWorker logicWorker : logicWorkerList) {
                            logicWorker.performLogic(this.serverEnv, req, resp);
                        }
                        out.write(endPoint.renderEndPointResponse(this.serverEnv, req, resp));
                    }
                    catch (URLNotFoundException e) {
                        try {
                            FileRenderer.INSTANCE.renderFile(out, req.getUrl(), this.serverEnv.getDataFilesRoot());
                        }
                        catch (NotAuthorizedException ex) {
                            out.write(this.serverEnv.findErrorEndPointByStatusCode(StatusCode.FORBIDDEN_403).renderEndPointResponse(this.serverEnv, errorRequest, new ResponseDataImpl(StatusCode.NOT_FOUND_404)));
                            Log.error(e.getMessage());
                        }
                        catch (Exception ex) {
                            out.write(this.serverEnv.findErrorEndPointByStatusCode(StatusCode.NOT_FOUND_404).renderEndPointResponse(this.serverEnv, errorRequest, new ResponseDataImpl(StatusCode.NOT_FOUND_404)));
                            Log.info(ex.getMessage());
                        }
                    }
                    catch (NotAuthenticatedException e) {
                        out.write(this.serverEnv.findErrorEndPointByStatusCode(StatusCode.NOT_AUTHORIZED_401).renderEndPointResponse(this.serverEnv, errorRequest, new ResponseDataImpl(StatusCode.NOT_AUTHORIZED_401)));
                    }
                    catch (NotAuthorizedException e) {
                        out.write(this.serverEnv.findErrorEndPointByStatusCode(StatusCode.FORBIDDEN_403).renderEndPointResponse(this.serverEnv, errorRequest, new ResponseDataImpl(StatusCode.NOT_FOUND_404)));
                        Log.error(e.getMessage());
                    }
                    catch (HttpRedirect e) {
                        out.write(this.serverEnv.getRedirectData(e.getRedirectURL()).getBytes("UTF-8"));
                    }
                    catch (IOException e) {
                        out.write(this.serverEnv.findErrorEndPointByStatusCode(StatusCode.NOT_FOUND_404).renderEndPointResponse(this.serverEnv, errorRequest, new ResponseDataImpl(StatusCode.NOT_FOUND_404)));
                        Log.error(e.getMessage());
                    }
                }
                catch (HttpRequestLineException e) {
                    out.write(this.serverEnv.findErrorEndPointByStatusCode(StatusCode.BAD_REQUEST_400).renderEndPointResponse(this.serverEnv, errorRequest, new ResponseDataImpl(StatusCode.BAD_REQUEST_400)));
                    Log.info(e.getMessage());
                }
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            Log.error(e.getMessage());
        }
        Log.debug("Call time in milliseconds: " + (System.currentTimeMillis() - startTime));
    }

    private void authorize(ServerEndPoint endPoint, List<Role> roleList) throws NotAuthenticatedException, NotAuthorizedException {
        boolean denied = false;
        boolean authorized = false;
        for (Role role : roleList) {
            if (endPoint.getDenyRoles().contains((Object)role)) {
                if (role == Role.NOT_AUTHENTICATED) {
                    throw new NotAuthenticatedException();
                }
                denied = true;
            }
            if (!endPoint.getAccessRoles().contains((Object)role)) continue;
            authorized = true;
        }
        if (!authorized || denied) {
            throw new NotAuthorizedException();
        }
    }
}

