/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import org.foilage.authorization.exceptions.NotAuthorizedException;
import org.foilage.utils.log.Log;

public enum FileRenderer {
    INSTANCE;


    public void renderFile(OutputStream outImg, String url, File dataFilesRoot) throws IOException, NotAuthorizedException {
        if (!this.verifyFile(url, dataFilesRoot)) {
            throw new NotAuthorizedException("Client trying to retrieve information outside data files root. Tried path: " + url);
        }
        outImg.write(Files.readAllBytes(new File(dataFilesRoot.toString() + url).toPath()));
    }

    private boolean verifyFile(String url, File dataFilesRoot) {
        try {
            File callFile = new File(dataFilesRoot.toString() + url).getCanonicalFile();
            for (File parent = callFile.getParentFile(); parent != null; parent = parent.getParentFile()) {
                if (!dataFilesRoot.equals(parent)) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            Log.error(e.getMessage());
            return false;
        }
    }
}

