/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.foilage.http.StatusCode;
import org.foilage.http.server.ClientSocketThread;
import org.foilage.http.server.DefaultWWWErrorEndPoint;
import org.foilage.http.server.HttpServerEnvironment;
import org.foilage.http.server.LogicWorker;
import org.foilage.http.server.PreEndPointLogicWorker;
import org.foilage.http.server.ServerEndPoint;
import org.foilage.http.server.TestEndPoint;
import org.foilage.http.server.TestLogicWorker;
import org.foilage.utils.log.Log;

public class HttpServer {
    protected final HttpServerEnvironment environment;
    public static boolean SERVER_RUNNING = true;

    public static void main(String[] args) {
        ArrayList<ServerEndPoint> endPointList = new ArrayList<ServerEndPoint>();
        ArrayList<LogicWorker> logicList = new ArrayList<LogicWorker>();
        logicList.add(new TestLogicWorker());
        endPointList.add(new TestEndPoint(Arrays.asList("/"), logicList));
        endPointList.add(new TestEndPoint(Arrays.asList("/test"), new ArrayList<LogicWorker>()));
        endPointList.add(new TestEndPoint(Arrays.asList("/all/*"), new ArrayList<LogicWorker>()));
        ArrayList<ServerEndPoint> errorEndPointList = new ArrayList<ServerEndPoint>();
        errorEndPointList.add(new DefaultWWWErrorEndPoint(Arrays.asList(StatusCode.NOT_FOUND_404.getName()), "Page not found!", "Could not find a page with the provided url!"));
        ArrayList<Locale> localesList = new ArrayList<Locale>();
        localesList.add(new Locale("sv", "SE"));
        localesList.add(Locale.ENGLISH);
        new HttpServer(new HttpServerEnvironment("#42", "localhost", "http://localhost:8000", 8000, 8192, false, new File("/home/fredrik/Downloads/"), new ArrayList<PreEndPointLogicWorker>(), endPointList, errorEndPointList, new DefaultWWWErrorEndPoint(Arrays.asList("/error"), "An error occurred!", "Unfortunately an error has occurred that we couldn't handle."), localesList));
    }

    protected HttpServer(HttpServerEnvironment environment) {
        this.environment = environment;
        try {
            ServerSocket serverSocket = new ServerSocket(environment.getPort());
            Log.info("Http server " + environment.getServerName() + " running on port " + environment.getPort() + ".");
            while (SERVER_RUNNING) {
                try {
                    new Thread(new ClientSocketThread(serverSocket.accept(), environment)).start();
                }
                catch (IOException e) {
                    Log.error(e.getMessage());
                }
            }
        }
        catch (IOException e) {
            Log.error(e.getMessage());
        }
        System.exit(0);
    }
}

