/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import java.util.List;
import java.util.Map;
import org.foilage.http.RequestMethod;
import org.foilage.http.server.SessionObject;
import org.foilage.http.server.UploadedFile;
import org.foilage.utils.checkers.NullChecker;
import org.foilage.utils.log.Log;

public class RequestData {
    private final RequestMethod method;
    private final String baseUrl;
    private final String url;
    private final Map<String, String> headerMap;
    private final Map<String, String> parameterMap;
    private final List<UploadedFile> fileList;
    private final String messageBody;
    private SessionObject session = null;

    public RequestData(RequestMethod method, String baseUrl, String url, Map<String, String> headerMap, Map<String, String> parameterMap, List<UploadedFile> fileList, String messageBody) {
        this.method = NullChecker.notNull(method);
        this.baseUrl = NullChecker.notNull(baseUrl);
        this.url = NullChecker.notNull(url);
        this.headerMap = NullChecker.notNull(headerMap);
        this.parameterMap = NullChecker.notNull(parameterMap);
        this.fileList = NullChecker.notNull(fileList);
        this.messageBody = NullChecker.notNull(messageBody);
    }

    public RequestMethod getMethod() {
        return this.method;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getHeaderMap() {
        return this.headerMap;
    }

    public String getHeader(String header) {
        return this.headerMap.get(header);
    }

    public boolean hasParam(String parameter) {
        return this.parameterMap.containsKey(parameter);
    }

    public Map<String, String> getParameterMap() {
        return this.parameterMap;
    }

    public String getParam(String parameter) {
        return this.parameterMap.get(parameter);
    }

    public int getIntParam(String parameter) {
        try {
            return Integer.parseInt(this.parameterMap.get(parameter));
        }
        catch (NumberFormatException e) {
            Log.info("In parameter " + parameter + " with value " + this.parameterMap.get(parameter) + " not an integer.");
            return Integer.MIN_VALUE;
        }
    }

    public float getFloatParam(String parameter) {
        try {
            return Float.parseFloat(this.parameterMap.get(parameter).replaceAll(",", "."));
        }
        catch (NumberFormatException e) {
            Log.info("In parameter " + parameter + " with value " + this.parameterMap.get(parameter) + " not an float.");
            return -2.1474836E9f;
        }
    }

    public List<UploadedFile> getFileList() {
        return this.fileList;
    }

    public String getMessageBody() {
        return this.messageBody;
    }

    public SessionObject getSession() {
        return this.session;
    }

    public void setSession(SessionObject session) {
        this.session = session;
    }
}

