/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.foilage.http.RequestMethod;
import org.foilage.http.exceptions.HttpRequestLineException;
import org.foilage.http.server.RequestData;
import org.foilage.http.server.UploadedFile;
import org.foilage.model.MimeType;
import org.foilage.utils.log.Log;

public enum RequestReader {
    INSTANCE;


    public RequestData readInData(String baseUrl, InputStream inputStream, int bufferSize) throws HttpRequestLineException, IOException {
        String headerString;
        byte[] buffer = new byte[bufferSize];
        int read = 0;
        int bufferLength = 0;
        int splitByte = 0;
        int contentLength = -1;
        Map<Object, Object> headerMap = new HashMap();
        while (read > -1 && contentLength != bufferLength) {
            try {
                read = inputStream.read(buffer, bufferLength, bufferSize - bufferLength);
            }
            catch (Exception e) {
                Log.error(e.getMessage());
            }
            if (splitByte != 0 || (splitByte = this.findHeaderEnd(buffer, bufferLength += read)) == 0) continue;
            headerString = new String(Arrays.copyOf(buffer, splitByte));
            headerMap = this.parseHeaderMap(Arrays.asList(headerString.split("\r\n")));
            Log.debug(headerString);
            if (headerMap.containsKey("content-length")) {
                contentLength = splitByte + Integer.parseInt((String)headerMap.get("content-length"));
                continue;
            }
            contentLength = bufferLength;
        }
        if (bufferLength > 0) {
            Log.trace(new String(Arrays.copyOf(buffer, bufferLength)));
            headerString = new String(Arrays.copyOf(buffer, bufferLength));
            ArrayList<String> requestDataLines = new ArrayList<String>();
            byte[] dataBuffer = new byte[bufferLength - splitByte];
            System.arraycopy(buffer, splitByte, dataBuffer, 0, bufferLength - splitByte);
            for (String s : headerString.split("\r\n")) {
                requestDataLines.add(s);
            }
            String[] requestLine = ((String)requestDataLines.get(0)).split("\\ ");
            RequestMethod requestMethod = this.parseRequestMethod(requestLine);
            HashMap<String, String> parameterMap = new HashMap();
            ArrayList<UploadedFile> fileList = new ArrayList<UploadedFile>();
            if (headerMap.containsKey("content-type") && ((String)headerMap.get("content-type")).startsWith("multipart/form-data")) {
                String boundaryString = "--" + ((String)headerMap.get("content-type")).split("boundary=")[1];
                boolean startFound = false;
                for (int pos = 0; pos < requestDataLines.size(); ++pos) {
                    if (startFound) {
                        if (!boundaryString.equals(requestDataLines.get(pos))) continue;
                        ++pos;
                        String data = "";
                        String name = "";
                        String fileName = "";
                        MimeType mimeType = MimeType.NONE;
                        while (!boundaryString.equals(requestDataLines.get(pos)) && !(boundaryString + "--").equals(requestDataLines.get(pos))) {
                            if (((String)requestDataLines.get(pos)).startsWith("Content-Disposition")) {
                                for (String d : ((String)requestDataLines.get(pos)).split(";")) {
                                    if (d.startsWith(" name=")) {
                                        name = d.split("\\\"")[1];
                                        continue;
                                    }
                                    if (!d.startsWith(" filename=")) continue;
                                    fileName = d.split("\\\"")[1];
                                }
                            } else if (((String)requestDataLines.get(pos)).startsWith("Content-Type")) {
                                mimeType = MimeType.parseType(((String)requestDataLines.get(pos)).split(": ")[1]);
                            } else if (((String)requestDataLines.get(pos)).length() > 0) {
                                data = data + (String)requestDataLines.get(pos);
                            }
                            ++pos;
                        }
                        if (mimeType == MimeType.NONE) {
                            parameterMap.put(name, data);
                        } else {
                            fileList.add(new UploadedFile(fileName, mimeType, data.getBytes()));
                        }
                        --pos;
                        continue;
                    }
                    if (((String)requestDataLines.get(pos)).length() != 0) continue;
                    startFound = true;
                }
            } else {
                parameterMap = this.parseParameterMap(requestLine[1]);
                if (requestMethod == RequestMethod.POST) {
                    this.parsePostParameters(parameterMap, (String)requestDataLines.get(requestDataLines.size() - 1));
                }
            }
            return new RequestData(requestMethod, baseUrl, this.parseRequestURL(requestLine), headerMap, parameterMap, fileList, new String(dataBuffer));
        }
        throw new HttpRequestLineException("Request line wrongly formatted, empty request.");
    }

    private RequestMethod parseRequestMethod(String[] requestLine) throws HttpRequestLineException {
        if (requestLine.length == 3) {
            return RequestMethod.findByName(requestLine[0]);
        }
        throw new HttpRequestLineException("Request line wrongly formatted, not containing 3 parts.");
    }

    private String parseRequestURL(String[] requestLines) {
        return requestLines[1].split("\\?")[0];
    }

    private int findHeaderEnd(byte[] buf, int bufferLength) {
        int splitbyte = 0;
        while (splitbyte + 3 < bufferLength) {
            if (buf[splitbyte] == 13 && buf[splitbyte + 1] == 10 && buf[splitbyte + 2] == 13 && buf[splitbyte + 3] == 10) {
                return splitbyte + 4;
            }
            ++splitbyte;
        }
        return 0;
    }

    private Map<String, String> parseHeaderMap(List<String> dataList) {
        HashMap<String, String> requestMap = new HashMap<String, String>();
        for (int i = 1; i < dataList.size(); ++i) {
            String[] split = dataList.get(i).split(":");
            if (split.length <= 1) continue;
            String data = "";
            for (int si = 1; si < split.length; ++si) {
                if (si > 1) {
                    data = data + ":";
                }
                data = data + split[si];
            }
            if ("content-type".equalsIgnoreCase(split[0]) && data.startsWith("multipart/form-data")) {
                requestMap.put(split[0].toLowerCase(), data.split(";")[0].trim());
                continue;
            }
            requestMap.put(split[0].toLowerCase(), data.trim());
        }
        return requestMap;
    }

    private Map<String, String> parseParameterMap(String urlString) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (urlString.contains("?")) {
            String[] paramArray;
            for (String param : paramArray = urlString.split("\\?")[1].split("\\&")) {
                try {
                    String[] p = param.split("=");
                    parameterMap.put(p[0], URLDecoder.decode(p[1], "UTF-8"));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    Log.info("Malformed url parameter " + param);
                }
                catch (UnsupportedEncodingException e) {
                    Log.error("Unsupported encoding url parameter " + param);
                }
            }
        }
        return parameterMap;
    }

    private void parsePostParameters(Map<String, String> parameterMap, String parameterLine) {
        for (String param : parameterLine.split("&")) {
            if (!param.contains("=")) continue;
            String[] val = param.split("=");
            if (val.length > 1) {
                try {
                    parameterMap.put(val[0], URLDecoder.decode(val[1], "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    Log.error("Unsupported encoding post parameter " + param);
                }
                continue;
            }
            parameterMap.put(val[0], "");
        }
    }
}

