/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.foilage.authorization.Role;
import org.foilage.http.StatusCode;
import org.foilage.http.server.HttpServerEnvironment;
import org.foilage.http.server.LogicWorker;
import org.foilage.http.server.RequestData;
import org.foilage.http.server.ResponseData;
import org.foilage.http.server.ServerEndPoint;

public abstract class RestEndPoint
extends ServerEndPoint {
    protected RestEndPoint(List<String> path, List<Role> accessRoles, List<Role> denyRoles, List<LogicWorker> preRenderLogicList) {
        super(path, accessRoles, denyRoles, preRenderLogicList);
    }

    protected RestEndPoint(List<String> path, List<Role> accessRoles, List<Role> denyRoles, boolean catchAllBelow, List<LogicWorker> preRenderLogicList) {
        super(path, accessRoles, denyRoles, catchAllBelow, preRenderLogicList);
    }

    public byte[] renderEndPointResponse(HttpServerEnvironment serverEnv, RequestData req, ResponseData resp) {
        StringBuilder sb = new StringBuilder();
        String responseData = this.renderSpecificEndPointResponse(serverEnv, req, resp);
        if (responseData.startsWith("HTTP/1.1")) {
            sb.append(responseData);
        } else {
            sb.append("HTTP/1.1 ");
            sb.append(resp.getResponseCode().getId());
            sb.append(" ");
            sb.append(resp.getResponseCode().getName());
            sb.append("\r\n");
            sb.append("Date: ");
            sb.append(LocalDateTime.now().minusHours(1L).format(DateTimeFormatter.ofPattern("EEE, dd MMMM YYYY HH:mm:ss")));
            sb.append(" GMT\r\n");
            sb.append("Server: ");
            sb.append(serverEnv.getServerName());
            sb.append("\r\n");
            sb.append("Connection: close\r\n");
            sb.append("\r\n");
            sb.append(responseData);
            sb.append("\r\n");
        }
        try {
            return sb.toString().getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return sb.toString().getBytes();
        }
    }

    protected String renderSpecificEndPointResponse(HttpServerEnvironment serverEnv, RequestData req, ResponseData resp) {
        switch (req.getMethod()) {
            case GET: {
                return this.renderEndPointGetResponse(serverEnv, req, resp);
            }
            case POST: {
                return this.renderEndPointPostResponse(serverEnv, req, resp);
            }
            case HEAD: {
                return this.renderEndPointHeadResponse(serverEnv, req, resp);
            }
            case PUT: {
                return this.renderEndPointPutResponse(serverEnv, req, resp);
            }
            case DELETE: {
                return this.renderEndPointDeleteResponse(serverEnv, req, resp);
            }
            case CONNECT: {
                return this.renderEndPointConnectResponse(serverEnv, req, resp);
            }
            case OPTIONS: {
                return this.renderEndPointOptionsResponse(serverEnv, req, resp);
            }
            case TRACE: {
                return this.renderEndPointTraceResponse(serverEnv, req, resp);
            }
        }
        return this.renderGeneralNotImplementedResponse(serverEnv);
    }

    protected String renderGeneralNotImplementedResponse(HttpServerEnvironment serverEnvironment) {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP/1.1 " + StatusCode.NOT_IMPLEMENTED_501.getId() + " " + StatusCode.NOT_IMPLEMENTED_501.getName() + "\r\n");
        sb.append(LocalDateTime.now().minusHours(1L).format(DateTimeFormatter.ofPattern("EEE, dd MMMM YYYY HH:mm:ss")));
        sb.append(" GMT\r\n");
        sb.append("Server: " + serverEnvironment.getServerName() + "\r\n");
        sb.append("Connection: close\r\n");
        return sb.toString();
    }

    protected String renderEndPointGetResponse(HttpServerEnvironment serverEnvironment, RequestData req, ResponseData resp) {
        return this.renderGeneralNotImplementedResponse(serverEnvironment);
    }

    protected String renderEndPointHeadResponse(HttpServerEnvironment serverEnvironment, RequestData req, ResponseData resp) {
        return this.renderGeneralNotImplementedResponse(serverEnvironment);
    }

    protected String renderEndPointPostResponse(HttpServerEnvironment serverEnvironment, RequestData req, ResponseData resp) {
        return this.renderGeneralNotImplementedResponse(serverEnvironment);
    }

    protected String renderEndPointPutResponse(HttpServerEnvironment serverEnvironment, RequestData req, ResponseData resp) {
        return this.renderGeneralNotImplementedResponse(serverEnvironment);
    }

    protected String renderEndPointDeleteResponse(HttpServerEnvironment serverEnvironment, RequestData req, ResponseData resp) {
        return this.renderGeneralNotImplementedResponse(serverEnvironment);
    }

    protected String renderEndPointConnectResponse(HttpServerEnvironment serverEnvironment, RequestData req, ResponseData resp) {
        return this.renderGeneralNotImplementedResponse(serverEnvironment);
    }

    protected String renderEndPointOptionsResponse(HttpServerEnvironment serverEnvironment, RequestData req, ResponseData resp) {
        return this.renderGeneralNotImplementedResponse(serverEnvironment);
    }

    protected String renderEndPointTraceResponse(HttpServerEnvironment serverEnvironment, RequestData req, ResponseData resp) {
        return this.renderGeneralNotImplementedResponse(serverEnvironment);
    }
}

