/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.foilage.authorization.Role;
import org.foilage.http.server.HttpServerEnvironment;
import org.foilage.http.server.LogicWorker;
import org.foilage.http.server.RequestData;
import org.foilage.http.server.ResponseData;
import org.foilage.utils.log.Log;

public abstract class ServerEndPoint<R extends ResponseData> {
    private final List<String> path;
    private final boolean catchAllBelow;
    private final List<Role> accessRoles;
    private final List<Role> denyRoles;
    protected final List<LogicWorker> preRenderLogicList;
    private static final String TWO_HOURS = "7200";
    private static final String THIRTY_DAYS = "2592000";

    protected ServerEndPoint(List<String> path, List<Role> accessRoles, List<Role> denyRoles) {
        this.path = path;
        this.accessRoles = accessRoles;
        this.denyRoles = denyRoles;
        this.catchAllBelow = false;
        this.preRenderLogicList = new ArrayList<LogicWorker>();
    }

    protected ServerEndPoint(List<String> path, List<Role> accessRoles, List<Role> denyRoles, List<LogicWorker> preRenderLogicList) {
        this.path = path;
        this.accessRoles = accessRoles;
        this.denyRoles = denyRoles;
        this.catchAllBelow = false;
        this.preRenderLogicList = preRenderLogicList;
    }

    protected ServerEndPoint(List<String> path, List<Role> accessRoles, List<Role> denyRoles, boolean catchAllBelow, List<LogicWorker> preRenderLogicList) {
        this.path = path;
        this.accessRoles = accessRoles;
        this.denyRoles = denyRoles;
        this.catchAllBelow = catchAllBelow;
        this.preRenderLogicList = preRenderLogicList;
    }

    public List<String> getPath() {
        return this.path;
    }

    public boolean isCatchAllBelow() {
        return this.catchAllBelow;
    }

    public List<LogicWorker> getPreRenderLogicList() {
        return this.preRenderLogicList;
    }

    public byte[] renderEndPointResponse(HttpServerEnvironment serverEnv, RequestData req, R resp) {
        StringBuilder sb = new StringBuilder();
        String responseData = this.renderSpecificEndPointResponse(serverEnv, req, resp);
        sb.append("HTTP/1.1 ");
        sb.append(resp.getResponseCode().getId());
        sb.append(" ");
        sb.append(resp.getResponseCode().getName());
        sb.append("\r\n");
        sb.append("Date: ");
        sb.append(LocalDateTime.now().minusHours(1L).format(DateTimeFormatter.ofPattern("EEE, dd MMMM YYYY HH:mm:ss")));
        sb.append(" GMT\r\n");
        sb.append("Server: ");
        sb.append(serverEnv.getServerName());
        sb.append("\r\n");
        if (serverEnv.isSessionsActive() && req.getSession() != null && req.getSession().isCreateClientCookie()) {
            sb.append("Set-Cookie:");
            sb.append("X-FOILAGE-SESSION-ID=");
            sb.append(req.getSession().getSessionId());
            sb.append("; domain=");
            sb.append(serverEnv.getDomain());
            sb.append(";expires=");
            sb.append(LocalDateTime.now().plusHours(2L).format(DateTimeFormatter.ofPattern("EEE, dd LLL YYYY HH:mm:ss")));
            sb.append(";max-age=");
            sb.append(TWO_HOURS);
            sb.append(";path=/;\r\n");
            req.getSession().setCreateClientCookie(false);
        }
        if (serverEnv.isSessionsActive() && req.getSession() != null && req.getSession().isCreateAutoLoginCookie()) {
            sb.append("Set-Cookie:");
            sb.append("X-FOILAGE-AUTOLOGIN-ID=");
            sb.append(req.getSession().getSessionId());
            sb.append("; domain=");
            sb.append(serverEnv.getDomain());
            sb.append(";expires=");
            sb.append(LocalDateTime.now().plusDays(30L).format(DateTimeFormatter.ofPattern("EEE, dd LLL YYYY HH:mm:ss")));
            sb.append(";max-age=");
            sb.append(THIRTY_DAYS);
            sb.append(";path=/;\r\n");
            req.getSession().setCreateAutoLoginCookie(true);
        }
        sb.append("Connection: close\r\n");
        sb.append("\r\n");
        sb.append(responseData);
        sb.append("\r\n");
        Log.debug("-------------RESPONSE-------------");
        Log.debug(sb.toString());
        try {
            return sb.toString().getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return sb.toString().getBytes();
        }
    }

    protected abstract String renderSpecificEndPointResponse(HttpServerEnvironment var1, RequestData var2, R var3);

    protected abstract R createResponseData();

    public List<Role> getAccessRoles() {
        return this.accessRoles;
    }

    public List<Role> getDenyRoles() {
        return this.denyRoles;
    }
}

