/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.foilage.authorization.Role;
import org.foilage.utils.checkers.NullChecker;

public class SessionObject {
    private LocalDateTime createdDate;
    private LocalDateTime lastActionDate;
    private String sessionId;
    private String ipAddress;
    private List<Role> roleList;
    private int userId;
    private boolean createClientCookie;
    private boolean createAutoLoginCookie;

    public SessionObject(LocalDateTime createdDate, LocalDateTime lastActionDate, String sessionId, String ipAddress, boolean createClientCookie, boolean createAutoLoginCookie) {
        this.createdDate = NullChecker.notNull(createdDate);
        this.lastActionDate = NullChecker.notNull(lastActionDate);
        this.sessionId = NullChecker.notNull(sessionId);
        this.ipAddress = NullChecker.notNull(ipAddress);
        this.roleList = new ArrayList<Role>();
        this.roleList.add(Role.NOT_AUTHENTICATED);
        this.userId = 0;
        this.createClientCookie = createClientCookie;
        this.createAutoLoginCookie = createAutoLoginCookie;
    }

    public LocalDateTime getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(LocalDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public LocalDateTime getLastActionDate() {
        return this.lastActionDate;
    }

    public void setLastActionDate(LocalDateTime lastActionDate) {
        this.lastActionDate = lastActionDate;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public List<Role> getRoleList() {
        return this.roleList;
    }

    public void setRoleList(List<Role> roleList) {
        this.roleList = roleList;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public boolean isCreateClientCookie() {
        return this.createClientCookie;
    }

    public void setCreateClientCookie(boolean createClientCookie) {
        this.createClientCookie = createClientCookie;
    }

    public boolean isCreateAutoLoginCookie() {
        return this.createAutoLoginCookie;
    }

    public void setCreateAutoLoginCookie(boolean createAutoLoginCookie) {
        this.createAutoLoginCookie = createAutoLoginCookie;
    }
}

