/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.util.HashMap;
import java.util.Map;
import org.foilage.http.server.SessionObject;
import org.foilage.utils.Now;

public enum SessionStore {
    I;

    private final int maxIdle = 3600;
    private Map<String, SessionObject> activeMap = new HashMap<String, SessionObject>();

    public boolean hasSession(String sessionId, String ip) {
        if (sessionId == null || sessionId.length() == 0) {
            return false;
        }
        String id = sessionId.replace("X-FOILAGE-SESSION-ID=", "");
        SessionObject obj = this.activeMap.get(id);
        if (obj == null) {
            return false;
        }
        obj.setLastActionDate(Now.localDateTime());
        return true;
    }

    public SessionObject getSession(String sessionId, String ip) {
        if (sessionId == null || sessionId.length() == 0) {
            return this.addSession(ip);
        }
        String id = "";
        for (String parameter : sessionId.split(";")) {
            if (!parameter.trim().startsWith("X-FOILAGE-SESSION-ID=")) continue;
            id = parameter.trim().replace("X-FOILAGE-SESSION-ID=", "");
        }
        SessionObject obj = this.activeMap.get(id);
        if (obj == null) {
            return this.addSession(ip);
        }
        if (!ip.equalsIgnoreCase(obj.getIpAddress())) {
            return this.addSession(ip);
        }
        if (Now.localDateTime().isAfter(obj.getLastActionDate().plusSeconds(3600L))) {
            return this.addSession(ip);
        }
        obj.setLastActionDate(Now.localDateTime());
        return obj;
    }

    private SessionObject addSession(String ip) {
        SessionObject sessionObject = new SessionObject(Now.localDateTime(), Now.localDateTime(), Base64.encode((Math.random() * 1.0E13 + ip + System.currentTimeMillis()).getBytes()), ip, true, false);
        this.activeMap.put(sessionObject.getSessionId(), sessionObject);
        return sessionObject;
    }
}

