/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.foilage.authorization.Role;
import org.foilage.http.html.ComponentGroup;
import org.foilage.http.html.HtmlComponent;
import org.foilage.http.html.body.A;
import org.foilage.http.html.body.BR;
import org.foilage.http.html.body.Body;
import org.foilage.http.html.body.H;
import org.foilage.http.html.body.Img;
import org.foilage.http.html.head.Head;
import org.foilage.http.html.head.HeadComponent;
import org.foilage.http.html.head.Link;
import org.foilage.http.html.head.Meta;
import org.foilage.http.html.head.MetaName;
import org.foilage.http.html.head.Rel;
import org.foilage.http.html.head.Title;
import org.foilage.http.server.LogicWorker;
import org.foilage.http.server.RequestData;
import org.foilage.http.server.TestResponseData;
import org.foilage.http.server.WWWEndPoint;
import org.foilage.model.MimeType;

public class TestEndPoint
extends WWWEndPoint<TestResponseData> {
    public TestEndPoint(List<String> path, List<LogicWorker> preRenderLogicList) {
        super(path, Arrays.asList(Role.ADMIN), new ArrayList<Role>(), preRenderLogicList);
    }

    @Override
    protected String renderHead(RequestData req, TestResponseData resp) {
        Head.Builder head = new Head.Builder();
        head.add((HeadComponent)new Title("Test titel"));
        head.add((HeadComponent)new Meta(MetaName.CHARSET, "UTF-8"));
        head.add((HeadComponent)new Meta(MetaName.AUTHOR, "Fredrik Gustavsson"));
        head.add((HeadComponent)new Link.Builder("test.css", Rel.STYLESHEET).mimeType(MimeType.CSS).build());
        return head.build().getHtml(new ComponentGroup(head.build()));
    }

    @Override
    protected String renderBody(RequestData req, TestResponseData resp) {
        Body.Builder body = new Body.Builder();
        body.add((HtmlComponent)((H.Builder)new H.Builder("1", "Test ext").id("test_id")).build());
        body.add(new HtmlComponent[]{((A.Builder)new A.Builder("Test2", "Test l\u00e4nk").onClick("return confirm('G\u00e5 till l\u00e4nken?');")).build(), BR.I1});
        body.add((HtmlComponent)new Img("img.png", "En bild"));
        return body.build().getHtml(new ComponentGroup(body.build()));
    }

    @Override
    protected TestResponseData createResponseData() {
        return new TestResponseData();
    }
}

