/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server;

import java.util.List;
import org.foilage.authorization.Role;
import org.foilage.http.server.HttpServerEnvironment;
import org.foilage.http.server.LogicWorker;
import org.foilage.http.server.RequestData;
import org.foilage.http.server.ResponseData;
import org.foilage.http.server.ServerEndPoint;

public abstract class WWWEndPoint<R extends ResponseData>
extends ServerEndPoint<R> {
    protected WWWEndPoint(List<String> path, List<Role> accessRoles, List<Role> denyRoles) {
        super(path, accessRoles, denyRoles);
    }

    protected WWWEndPoint(List<String> path, List<Role> accessRoles, List<Role> denyRoles, List<LogicWorker> preRenderLogicList) {
        super(path, accessRoles, denyRoles, preRenderLogicList);
    }

    protected WWWEndPoint(List<String> path, List<Role> accessRoles, List<Role> denyRoles, boolean catchAllBelow, List<LogicWorker> preRenderLogicList) {
        super(path, accessRoles, denyRoles, catchAllBelow, preRenderLogicList);
    }

    @Override
    protected String renderSpecificEndPointResponse(HttpServerEnvironment serverEnv, RequestData req, R resp) {
        StringBuilder sb = new StringBuilder();
        sb.append("<!DOCTYPE html>\n");
        sb.append("<html>\n");
        sb.append(this.renderHead(req, resp));
        sb.append(this.renderBody(req, resp));
        sb.append("</html>");
        return sb.toString();
    }

    protected abstract String renderHead(RequestData var1, R var2);

    protected abstract String renderBody(RequestData var1, R var2);
}

