/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server.dao.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.foilage.authorization.exceptions.NotAuthenticatedException;
import org.foilage.dao.ProxyMySQLDAO;
import org.foilage.database.CommitType;
import org.foilage.database.MySQLConnectionPool;
import org.foilage.http.server.dao.SavedLoginDAO;
import org.foilage.http.server.model.SavedLogin;
import org.foilage.http.server.model.impl.SavedLoginImpl;

public class SavedLoginMysqlDAOImpl
extends ProxyMySQLDAO<SavedLoginMysqlDAOImpl>
implements SavedLoginDAO {
    public SavedLoginMysqlDAOImpl(MySQLConnectionPool connectionPool) {
        super(connectionPool);
    }

    @Override
    public void add(SavedLogin savedLogin) {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.connectionPool.getConnection(CommitType.AUTO);
            ps = this.prepareAdd(con, savedLogin);
            ps.execute();
            this.connectionPool.returnConnection(con, ps);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(this.generateSQLErrorMessage(e, this.getClass(), this.getClass().getEnclosingMethod()));
            }
            catch (Throwable throwable) {
                this.connectionPool.returnConnection(con, ps);
                throw throwable;
            }
        }
    }

    private PreparedStatement prepareAdd(Connection con, SavedLogin savedLogin) throws SQLException {
        String query = "INSERT INTO login_save(user_id, login_hash, valid_from, valid_to, login_ip) VALUES(?, ?, ?, ?, ?)";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setInt(1, savedLogin.getUserId());
        ps.setString(2, savedLogin.getLoginHash());
        ps.setTimestamp(3, Timestamp.valueOf(savedLogin.getValidFrom()));
        ps.setTimestamp(4, Timestamp.valueOf(savedLogin.getValidTo()));
        ps.setString(5, savedLogin.getLoginIp());
        return ps;
    }

    @Override
    public SavedLogin getByHash(String hash) throws NotAuthenticatedException {
        Connection con = null;
        PreparedStatement ps = null;
        try {
            con = this.connectionPool.getConnection(CommitType.AUTO);
            ps = this.prepareGetByHash(con, hash);
            SavedLogin savedLogin = this.executeGetByHash(ps, hash);
            this.connectionPool.returnConnection(con, ps);
            return savedLogin;
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(this.generateSQLErrorMessage(e, this.getClass(), this.getClass().getEnclosingMethod()));
            }
            catch (Throwable throwable) {
                this.connectionPool.returnConnection(con, ps);
                throw throwable;
            }
        }
    }

    private PreparedStatement prepareGetByHash(Connection con, String hash) throws SQLException {
        String query = "SELECT * FROM login_save WHERE login_hash = ? AND valid_from <= ? AND valid_to >= ?";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setString(1, hash);
        ps.setTimestamp(2, Timestamp.valueOf(LocalDateTime.now()));
        ps.setTimestamp(3, Timestamp.valueOf(LocalDateTime.now()));
        return ps;
    }

    private SavedLogin executeGetByHash(PreparedStatement ps, String hash) throws SQLException, NotAuthenticatedException {
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            return this.createFromResultSet(rs);
        }
        throw new NotAuthenticatedException("Login attempt with saved hash not valid for hash " + hash);
    }

    private SavedLogin createFromResultSet(ResultSet rs) throws SQLException {
        return new SavedLoginImpl(rs.getInt("id"), rs.getInt("user_id"), rs.getString("login_hash"), rs.getTimestamp("valid_from").toLocalDateTime(), rs.getTimestamp("valid_to").toLocalDateTime(), rs.getString("login_ip"));
    }
}

