/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.http.server.model.impl;

import java.time.LocalDateTime;
import org.foilage.http.server.model.SavedLogin;
import org.foilage.utils.checkers.GreaterThenZeroChecker;
import org.foilage.utils.checkers.NullChecker;

public class SavedLoginImpl
implements SavedLogin {
    private final int id;
    private final int userId;
    private final String loginHash;
    private final LocalDateTime validFrom;
    private final LocalDateTime validTo;
    private final String loginIp;

    public SavedLoginImpl(int userId, String loginHash, LocalDateTime validFrom, LocalDateTime validTo, String loginIp) {
        this.id = 0;
        this.userId = GreaterThenZeroChecker.greaterThenZero(userId);
        this.loginHash = NullChecker.notNull(loginHash);
        this.validFrom = NullChecker.notNull(validFrom);
        this.validTo = NullChecker.notNull(validTo);
        this.loginIp = NullChecker.notNull(loginIp);
    }

    public SavedLoginImpl(int id, int userId, String loginHash, LocalDateTime validFrom, LocalDateTime validTo, String loginIp) {
        this.id = GreaterThenZeroChecker.greaterThenZero(id);
        this.userId = GreaterThenZeroChecker.greaterThenZero(userId);
        this.loginHash = NullChecker.notNull(loginHash);
        this.validFrom = NullChecker.notNull(validFrom);
        this.validTo = NullChecker.notNull(validTo);
        this.loginIp = NullChecker.notNull(loginIp);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getUserId() {
        return this.userId;
    }

    @Override
    public String getLoginHash() {
        return this.loginHash;
    }

    @Override
    public LocalDateTime getValidFrom() {
        return this.validFrom;
    }

    @Override
    public LocalDateTime getValidTo() {
        return this.validTo;
    }

    @Override
    public String getLoginIp() {
        return this.loginIp;
    }
}

