/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.model;

import org.foilage.model.MimeCategory;

public enum MimeType {
    MP3(MimeCategory.AUDIO, "mpeg"),
    JPG(MimeCategory.IMAGE, "jpeg"),
    GIF(MimeCategory.IMAGE, "gif"),
    PNG(MimeCategory.IMAGE, "png"),
    SHORTCUT_ICON(MimeCategory.IMAGE, "x-icon"),
    TIFF(MimeCategory.IMAGE, "tiff"),
    PDF(MimeCategory.APPLICATION, "pdf"),
    CSS(MimeCategory.TEXT, "css"),
    JAVA_SCRIPT(MimeCategory.TEXT, "javascript"),
    HTML(MimeCategory.TEXT, "html"),
    PLAIN_TEXT(MimeCategory.TEXT, "plain"),
    RITCH_TEXT(MimeCategory.TEXT, "richtext"),
    CSV(MimeCategory.TEXT, "csv"),
    V_CARD(MimeCategory.TEXT, "x-vcard"),
    XML(MimeCategory.TEXT, "xml"),
    NONE(MimeCategory.NONE, "");

    private MimeCategory category;
    private String mimeType;

    private MimeType(MimeCategory category, String mimeType) {
        this.category = category;
        this.mimeType = mimeType;
    }

    public static MimeType parseType(String mimeString) {
        String[] mimeArray = mimeString.split("/");
        for (MimeType type : MimeType.values()) {
            if (!type.category.getCategoryId().equalsIgnoreCase(mimeArray[0]) || !type.getMimeType().equalsIgnoreCase(mimeArray[1])) continue;
            return type;
        }
        throw new IllegalArgumentException("No valid mimetype found for " + mimeString);
    }

    public MimeCategory getCategory() {
        return this.category;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String toString() {
        return (Object)((Object)this.category) + "/" + this.mimeType;
    }
}

