/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.utils;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class ObjectPool<T> {
    private ConcurrentLinkedQueue<T> pool;
    private ScheduledExecutorService executorService;

    public ObjectPool(int minIdle) {
        this.initialize(minIdle);
    }

    public ObjectPool(final int minIdle, final int maxIdle, long validationInterval) {
        this.initialize(minIdle);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                block3: {
                    int size;
                    block2: {
                        size = ObjectPool.this.pool.size();
                        if (size >= minIdle) break block2;
                        int sizeToBeAdded = minIdle - size;
                        for (int i = 0; i < sizeToBeAdded; ++i) {
                            ObjectPool.this.pool.add(ObjectPool.this.createObject());
                        }
                        break block3;
                    }
                    if (size <= maxIdle) break block3;
                    int sizeToBeRemoved = size - maxIdle;
                    for (int i = 0; i < sizeToBeRemoved; ++i) {
                        ObjectPool.this.pool.poll();
                    }
                }
            }
        }, validationInterval, validationInterval, TimeUnit.SECONDS);
    }

    public T borrowObject() {
        T object = this.pool.poll();
        if (object == null) {
            object = this.createObject();
        }
        return object;
    }

    public void returnObject(T object) {
        if (object == null) {
            return;
        }
        this.pool.offer(object);
    }

    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    protected abstract T createObject();

    private void initialize(int minIdle) {
        this.pool = new ConcurrentLinkedQueue();
        for (int i = 0; i < minIdle; ++i) {
            this.pool.add(this.createObject());
        }
    }
}

