/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.utils;

import java.time.LocalDateTime;
import org.foilage.utils.checkers.NullChecker;

public enum TimeSourceType {
    SYSTEM(1, LocalDateTime.now()),
    EMULATED_STATIC(2, LocalDateTime.now());

    private final int id;
    private LocalDateTime emulatedTime;

    private TimeSourceType(int id, LocalDateTime emulatedTime) {
        this.id = id;
        this.emulatedTime = NullChecker.notNull(emulatedTime);
    }

    public int getId() {
        return this.id;
    }

    public LocalDateTime getEmulatedTime() {
        return this.emulatedTime;
    }

    public void setEmulatedTime(LocalDateTime emulatedTime) {
        this.emulatedTime = emulatedTime;
    }

    public static TimeSourceType getById(int id) {
        for (TimeSourceType type : TimeSourceType.values()) {
            if (id != type.getId()) continue;
            return type;
        }
        throw new IllegalArgumentException("No time source type exists with id " + id);
    }
}

