/*
 * Decompiled with CFR 0.152.
 */
package org.foilage.utils.checkers;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.foilage.annotations.AllowNull;
import org.foilage.annotations.GreaterThenZero;
import org.foilage.annotations.NotZero;
import org.foilage.utils.checkers.GreaterThenZeroChecker;
import org.foilage.utils.checkers.NullChecker;
import org.foilage.utils.checkers.ZeroChecker;

public class AbstractNullChecker {
    protected void notNullChecks(Method method, Object[] argumentList) {
        if (argumentList != null) {
            int i = 1;
            for (Object argument : argumentList) {
                if (this.shouldCheckNull(method.getParameterAnnotations()[i - 1])) {
                    NullChecker.notNull(argument, this.generateErrorMessage(method, i));
                }
                if (this.shouldCheckZero(method.getParameterAnnotations()[i - 1])) {
                    if (argument instanceof Integer) {
                        ZeroChecker.notZero((Integer)argument, this.generateZeroCheckErrorMessage(method, i));
                    } else if (argument instanceof Float) {
                        ZeroChecker.notZero(((Float)argument).floatValue(), this.generateZeroCheckErrorMessage(method, i));
                    } else if (argument instanceof Long) {
                        ZeroChecker.notZero((Long)argument, this.generateZeroCheckErrorMessage(method, i));
                    }
                    if (argument instanceof Double) {
                        ZeroChecker.notZero((Double)argument, this.generateZeroCheckErrorMessage(method, i));
                    }
                } else if (this.shouldCheckGreaterThenZero(method.getParameterAnnotations()[i - 1])) {
                    if (argument instanceof Integer) {
                        GreaterThenZeroChecker.greaterThenZero((Integer)argument, this.generateGreaterThenZeroCheckErrorMessage(method, i));
                    } else if (argument instanceof Float) {
                        GreaterThenZeroChecker.greaterThenZero(((Float)argument).floatValue(), this.generateGreaterThenZeroCheckErrorMessage(method, i));
                    } else if (argument instanceof Long) {
                        GreaterThenZeroChecker.greaterThenZero((Long)argument, this.generateGreaterThenZeroCheckErrorMessage(method, i));
                    }
                    if (argument instanceof Double) {
                        GreaterThenZeroChecker.greaterThenZero((Double)argument, this.generateGreaterThenZeroCheckErrorMessage(method, i));
                    }
                }
                ++i;
            }
        }
    }

    private boolean shouldCheckNull(Annotation[] parameterAnnotations) {
        for (Annotation annotation : parameterAnnotations) {
            if (annotation.annotationType() != AllowNull.class) continue;
            return false;
        }
        return true;
    }

    private boolean shouldCheckZero(Annotation[] parameterAnnotations) {
        for (Annotation annotation : parameterAnnotations) {
            if (annotation.annotationType() != NotZero.class) continue;
            return true;
        }
        return false;
    }

    private boolean shouldCheckGreaterThenZero(Annotation[] parameterAnnotations) {
        for (Annotation annotation : parameterAnnotations) {
            if (annotation.annotationType() != GreaterThenZero.class) continue;
            return true;
        }
        return false;
    }

    private String generateErrorMessage(Method method, int parameterId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Parameter number ");
        stringBuilder.append(parameterId);
        stringBuilder.append(" in class ");
        stringBuilder.append(method.getDeclaringClass().getName());
        stringBuilder.append(" and method ");
        stringBuilder.append(method.getName());
        stringBuilder.append(" can't be null!");
        return stringBuilder.toString();
    }

    private String generateZeroCheckErrorMessage(Method method, int parameterId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Parameter number ");
        stringBuilder.append(parameterId);
        stringBuilder.append(" in class ");
        stringBuilder.append(method.getDeclaringClass().getName());
        stringBuilder.append(" and method ");
        stringBuilder.append(method.getName());
        stringBuilder.append(" can't be 0!");
        return stringBuilder.toString();
    }

    private String generateGreaterThenZeroCheckErrorMessage(Method method, int parameterId) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Parameter number ");
        stringBuilder.append(parameterId);
        stringBuilder.append(" in class ");
        stringBuilder.append(method.getDeclaringClass().getName());
        stringBuilder.append(" and method ");
        stringBuilder.append(method.getName());
        stringBuilder.append(" can't be less then 0!");
        return stringBuilder.toString();
    }
}

